<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductsCategoryMain extends Model
{
    protected $table = 'products_category_main';
    protected $primaryKey = 'id_pro_cate_main';
    protected $fillable = [
        'products_category_name',
        'products_category_name_urdu',
        'products_category_status',
        'created_by',
        'created_at',
    ];

    // A main category has many sub-categories (parent level)
    public function subCategoriesParent()
    {
        return $this->hasMany(ProductsSubCategoryParent::class, 'pro_cate_main_id', 'id_pro_cate_main');
    }
}
