<?php

namespace App\Http\Controllers;

use App\ProductsCategory;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ProductsCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $product = ProductsCategory::all()
            //  $discounts = Discounts::all()
            ->join('users as u', 'u.id', 'po.created_by');
        $product = DB::table('products_category')
            ->join('users', 'users.id', 'products_category.created_by')
            ->select('products_category.*', 'users.name')->get();
        // dd($discounts);
        return view('product_category.index', compact('product'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $product = ProductsCategory::all();
        return view('product_category.create', compact('product'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $store = new ProductsCategory();
        $store->products_category_name = $request->products_category_name;
        $store->products_category_name_urdu = $request->products_category_name_urdu;
        $store->products_category_status = $request->products_category_status;
        // $store->products_category_status = "1";
        $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Product Category  Added Successfully");

        return redirect('product');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    // public function show()
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = ProductsCategory::where('id_products_category', $dec_id)->first();
        // $edit = currency_exchange_rate::all();

        return view('product_category.edit', compact('edit'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        // dd($dec_id);
        $update = ProductsCategory::where('id_products_category', $dec_id)->first();
        $update->products_category_name = $request->products_category_name;
        $update->products_category_name_urdu = $request->products_category_name_urdu;
        $update->products_category_status = $request->products_category_status;

        // $update->products_category_status = "1";
        $update->created_by = auth()->user()->id;
        $update->save();
        session()->flash('info', "Product Category  Updated  Successfully");

        return redirect('product');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ProductsCategory = ProductsCategory::findOrFail($id);
        $ProductsCategory->delete();
        session()->flash('warning', "Product Category Removed!");
        return redirect()->back();
    }
}
