@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Unit Types</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Unit Types List
        <span>
            <a href="{{ url('unit_type/create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Unit Type </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">Unit Type Name</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Operations</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($unit_types as $key => $unit_type)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $unit_type->name }}</td>
                                    <td>{{ $unit_type->status }}</td>
                                    <td>{{ date('d-m-Y', strtotime($unit_type->created_at)) }}</td>
                                    <td>
                                        <a class="btn btn-rounded btn-primary"
                                            href="{{ url('unit_type/edit/' . \Crypt::encrypt($unit_type->id_unit_type)) }}">
                                            Edit
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">Unit Type Name</th>
                                <th class="wd-10p">Status</th>
                                <th class="wd-10p">Created</th>
                                <th class="wd-10p">Operations</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

    </script>
@endpush
