<?php

namespace App\Http\Controllers;

use App\Employees;
use App\ReceiptVoucher;
use App\Http\Controllers\Controller;
use App\Payment;
use App\TransactionAccount;
use App\Voucher;
use App\VouchersUniqueNumber;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class ReceiptVoucherController extends Controller
{



    public function index()
    {
        $vouchersNumber = VouchersUniqueNumber::with('vouchers')->where('voucher_type', 'Receipt Voucher')->get();

        return view('receipt_voucher.index', compact('vouchersNumber'));
    }


    public function create()
    {
        $employees = Employees::all();
        $accounts = TransactionAccount::all();
        return view('receipt_voucher.create', compact('employees', 'accounts'));
    }

    public function store(Request $request)
    {
        // Validate the incoming data
        $request->validate([
            'voucherDate.*' => 'required|date',
            'accountNo.*' => 'required|string',
            'accountName.*' => 'required|string',
            'paymentMode.*' => 'required|string',
            'instrumentAmount.*' => 'nullable|string',
            'netAmount.*' => 'required|numeric',
            'noteRemarks.*' => 'nullable|string',
            'debitAMount.*' => 'nullable|numeric',
            'creditAmount.*' => 'nullable|numeric',
            'businessPartnerName.*' => 'nullable|string',
            'taxDebitYesNo.*' => 'required|string',
            'transactionAccountId.*' => 'required|string',
            'transactionAccountName.*' => 'required|string',
            'vDescription.*' => 'nullable|string',
            'voucherStatus.*' => 'required|string',
        ]);

        // Generate a unique journal voucher number (e.g., JV-XXXXX)
        $uniqueVoucherNumber = 'RV-' . str_pad(rand(0, 99999), 5, '0', STR_PAD_LEFT);

        // Create a new VouchersUniqueNumber record
        $voucherUniqueNumber = new VouchersUniqueNumber();
        $voucherUniqueNumber->voucher_type = 'Receipt Voucher';
        $voucherUniqueNumber->voucher_number = $uniqueVoucherNumber;
        $voucherUniqueNumber->save();  // Save the unique voucher number record first

        // Loop through each row and create a voucher record
        for ($i = 0; $i < count($request->accountNo); $i++) {
            $voucher = new Voucher();
            $voucher->vouchers_unique_number_id = $voucherUniqueNumber->id_vouchers_unique_number;  // Associate with unique voucher number
            $voucher->date = $request->voucherDate[$i];
            $voucher->account_no = $request->accountNo[$i];
            $voucher->account_title = $request->accountName[$i];
            $voucher->payment_mode = $request->paymentMode[$i];
            $voucher->instrument = $request->instrumentAmount[$i];
            $voucher->amount = $request->netAmount[$i];
            $voucher->remarks = $request->noteRemarks[$i];
            $voucher->debit = $request->debitAMount[$i];
            $voucher->credit = $request->creditAmount[$i];
            $voucher->partner_name = $request->businessPartnerName[$i];
            $voucher->tax_debit = $request->taxDebitYesNo[$i];
            $voucher->transaction_acc_no = $request->transactionAccountId[$i];
            $voucher->transaction_acc_name = $request->transactionAccountName[$i];
            $voucher->desciption = $request->vDescription[$i];
            $voucher->status = $request->voucherStatus[$i];
            // dd($voucherUniqueNumber);
            // Save the voucher
            $voucher->save();
        }

        // Redirect back with a success message
        return redirect()->route('receipt_voucher.list')->with('success', 'Vouchers have been created successfully.');
    }


    public function view($id)
    {
        $id = Crypt::decrypt($id);
        $vouchersNumber = VouchersUniqueNumber::with('vouchers')->where('voucher_type', 'Receipt Voucher')->where('id_vouchers_unique_number', $id)->first();
        $voucherSingle = $vouchersNumber->vouchers->first();
        return view('receipt_voucher.view', compact('vouchersNumber', 'voucherSingle'));
    }

    public function edit($encryptedId)
    {
        $id = Crypt::decrypt($encryptedId);
        $vouchersNumber = VouchersUniqueNumber::with('vouchers')->where('voucher_type', 'Receipt Voucher')->findOrFail($id);
        $voucherSingle = $vouchersNumber->vouchers->first();

        // Fetch employees and accounts for the form
        $employees = Employees::all();
        $accounts = TransactionAccount::all();

        return view('receipt_voucher.edit', compact('employees', 'accounts', 'vouchersNumber', 'voucherSingle'));
    }

    public function update(Request $request, $encryptedId)
    {
        // Validate the request data
        $request->validate([
            'voucherDate.*' => 'required|date',
            'accountNo.*' => 'required|string',
            'accountName.*' => 'required|string',
            'paymentMode.*' => 'required|string',
            'instrumentAmount.*' => 'nullable|string',
            'netAmount.*' => 'required|numeric',
            'noteRemarks.*' => 'nullable|string',
            'debitAMount.*' => 'nullable|numeric',
            'creditAmount.*' => 'nullable|numeric',
            'businessPartnerName.*' => 'nullable|string',
            'taxDebitYesNo.*' => 'required|string',
            'transactionAccountId.*' => 'required|string',
            'transactionAccountName.*' => 'required|string',
            'vDescription.*' => 'nullable|string',
            'voucherStatus.*' => 'required|string',
            'voucherIds.*' => 'nullable|integer'
        ]);


        if ($request->has('deletedVouchers')) {
            $deletedVouchers = explode(',', $request->input('deletedVouchers'));
            Voucher::whereIn('id_vouchers', $deletedVouchers)->delete();
        }

        $id = Crypt::decrypt($encryptedId);
        $voucherUniqueNumber = VouchersUniqueNumber::with('vouchers')->findOrFail($id);
        $existingVouchers = Voucher::where('vouchers_unique_number_id', $voucherUniqueNumber->id_vouchers_unique_number)->get();

        // Track new vouchers to be inserted
        $newVouchersData = [];

        // Track IDs to update and compare against existing ones
        $voucherIdsToUpdate = $request->input('voucherIds', []);
        $existingVoucherIds = $existingVouchers->pluck('id_vouchers')->toArray();

        // Process the vouchers from the request
        foreach ($request->input('voucherDate', []) as $index => $voucherDate) {
            $voucherId = $voucherIdsToUpdate[$index] ?? null;

            // Add new voucher
            $newVouchersData[] = [
                'vouchers_unique_number_id' => $voucherUniqueNumber->id_vouchers_unique_number,
                'date' => $voucherDate,
                'account_no' => $request->input('accountNo.' . $index),
                'account_title' => $request->input('accountName.' . $index),
                'payment_mode' => $request->input('paymentMode.' . $index),
                'instrument' => $request->input('instrumentAmount.' . $index),
                'amount' => $request->input('netAmount.' . $index),
                'remarks' => $request->input('noteRemarks.' . $index),
                'debit' => $request->input('debitAMount.' . $index),
                'credit' => $request->input('creditAmount.' . $index),
                'partner_name' => $request->input('businessPartnerName.' . $index),
                'tax_debit' => $request->input('taxDebitYesNo.' . $index),
                'transaction_acc_no' => $request->input('transactionAccountId.' . $index),
                'transaction_acc_name' => $request->input('transactionAccountName.' . $index),
                'desciption' => $request->input('vDescription.' . $index),
                'status' => $request->input('voucherStatus.' . $index)
            ];
            // dd($voucherId, $existingVoucherIds , $newVouchersData);
        }

        // Insert new vouchers
        if (!empty($newVouchersData)) {
            Voucher::insert($newVouchersData);
        }

        return redirect()->route('receipt_voucher.list')->with('success', 'Vouchers have been updated, and new vouchers have been added successfully.');
    }



    public function destroy(ReceiptVoucher $accountVoucher)
    {
        //
    }
}
