<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Voucher extends Model
{
    use HasFactory;
    protected $table = 'vouchers';
    protected $primaryKey = 'id_vouchers';
    protected $fillable = [
        'vouchers_unique_number_id',
        'account_no',
        'account_title',
        'payment_mode',
        'instrument',
        'amount',
        'remarks',
        'debit',
        'credit',
        'business_partner_type',
        'partner_name',
        'tax_debit',
        'transaction_acc_no',
        'transaction_acc_name',
        'desciption',
        'date',
        'status'
    ];

    /**
     * Get the unique voucher number associated with this voucher.
     */
    public function vouchersUniqueNumber()
    {
        return $this->belongsTo(VouchersUniqueNumber::class, 'vouchers_unique_number_id');
    }
}
