<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Unit_type;
use Illuminate\Http\Request;
use UnitEnum;

class Unit_typeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

    }
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //     $this->middleware(function ($request, $next) {
    //         $this->role_id = Auth::user()->role_id;
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         $ex = explode('/', $request->path());
    //         if (count($ex) >= 3) {
    //             $sliced = array_slice($ex, 0, -1);
    //         } else {
    //             $sliced = $ex;
    //         }

    //         $string = implode("/", $sliced);
    //         //                 dd($string);
    //         if (checkConstructor($this->role_id, count($ex) >= 3 ? $string . '/' : $string) == 1) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'store') !== false) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'update') !== false) {
    //             return $next($request);
    //         } else {
    //             abort(404);
    //         }
    //     });

    // }
    public function index()
    {
        $unit_types = Unit_type::all();

        return view('unit_type.index', compact('unit_types'));
    }

    public function create()
    {
        $unit_type = Unit_type::all();

        return view('unit_type.create' , compact('unit_type'));
    }

    public function store(Request $request)
    {
        // Validate the incoming request
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);

        // Create a new unit type using the validated data
        Unit_type::create([
            'name' => $validatedData['name'],
            'status' => $validatedData['status'],
        ]);

        // Redirect to the unit type index page with a success message
        return redirect('unit_type');
    }


public function edit($id)
{
    $dec_id = \Crypt::decrypt($id);
    $unit_type = Unit_type::findOrFail($dec_id);

    return view('unit_type.edit', compact('unit_type'));
}

public function update(Request $request, $id)
{
    $dec_id = \Crypt::decrypt($id);

    $validatedData = $request->validate([
        'name' => 'required|string|max:255',
        'status' => 'required|boolean',
    ]);

    $unit_type = Unit_type::findOrFail($dec_id);

    $unit_type->update([
        'name' => $validatedData['name'],
        'status' => $validatedData['status'],
    ]);

    return redirect()->route('unit_type.index')->with('success', 'Unit Type updated successfully.');
}

public function destroy($id)
{
    $unit_type = Unit_type::findOrFail($id);
    $unit_type->delete();
    session()->flash('warning', "Unit Type Removed!");
    return redirect()->back();
}


}
