<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    protected $primaryKey = 'id_sales';
    protected $table = 'sales';
    protected $fillable = [
        'bussiness_id',
        'good_receipts_truck_id',
        'customer_id',
        'date',
        's_no',
        'bill_no',
        'details',
        'bori_details',
        'balance',
        'paid',
        'status',
        'created_by',
    ];

    public function goodReceiptTruck()
    {
        return $this->belongsTo(GoodReceiptTruck::class, 'good_receipts_truck_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function salesItemsDetails()
    {
        return $this->hasMany(SalesItemDetail::class, 'sales_id');
    }
}
