@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Supplier</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Supplier<span>
            @can('Supplier add')
                <a href="{{ route('supplier.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Supplier</a>
            @endcan
        </span>
    </h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Supplier Name</th>
                                <th class="wd-10p">(کھاتہ)</th>
                                <th class="wd-10p">Supplier Email</th>
                                <th class="wd-10p">Supplier Address </th>
                                <th class="wd-10p">Contact Person </th>
                                <th class="wd-10p">Phone</th>
                                <th class="wd-10p">Website </th>
                                <th class="none">Status </th>
                                <th class="none">Created</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($suppliers as $key => $supplier)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $supplier->supplier_name }} </td>
                                    <td>{{ $supplier->supplier_name_urdu }}</td>
                                    <td>{{ $supplier->supplier_email }}</td>
                                    <td>{{ $supplier->supplier_address }}</td>
                                    <td>{{ $supplier->contact_person }}</td>
                                    <td>{{ $supplier->phone_1 }}</td>
                                    <td>{{ $supplier->website }}</td>
                                    <td>
                                        @if ($supplier->status == 1)
                                            <span class="btn btn-rounded btn-success text-white">Active</span>
                                        @else
                                            <span class="btn btn-rounded btn-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ date('d-m-Y', strtotime($supplier->created_at)) }}</td>
                                    <td>
                                        @can('Supplier edit')
                                            <a class="btn rounded shadow-base" title="Edit Supplier"
                                                href="{{ route('supplier.edit', \Crypt::encrypt($supplier->id_supplier)) }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i> <span
                                                    class="text-primary">Edit</span>
                                            </a>
                                        @endcan
                                        @can('Supplier view')
                                            <a class="btn rounded shadow-base" title="Supplier Brands"
                                                href="{{ route('supplier.brand', \Crypt::encrypt($supplier->id_supplier)) }}">
                                                <i class="fas fa-plus text-success"></i> <span class="text-success">
                                                    Add Brand</span>
                                            </a>
                                        @endcan
                                        @can('Supplier delete')
                                            <a class="btn rounded shadow-base" title="Remove Supplier" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ $supplier->id_supplier }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i> <span
                                                    class="text-danger">Remove</span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach


                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Supplier Name</th>
                                <th class="wd-10p">(کھاتہ)</th>
                                <th class="wd-10p">Supplier Email</th>
                                <th class="wd-10p">Supplier Address </th>
                                <th class="wd-10p">Contact Person </th>
                                <th class="wd-10p">Phone</th>
                                <th class="wd-10p">Website </th>
                                <th class="none">Status </th>
                                <th class="none">Created</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Supplier?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Brand Modal -->
    {{-- <div class="modal fade" id="brandModal" tabindex="-1" role="dialog" aria-labelledby="brandModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="brandModalLabel">Assign Brand to Supplier</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="brandForm" action="{{ route('supplier.assign.brand') }}" method="POST">
                        @csrf
                        <input type="hidden" name="supplier_id" id="supplier_id" value="">
                        <div class="form-group">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Select Brand</label>
                            <select class="form-control" name="brand_id" id="brand_id">
                                @foreach ($brands as $brand)
                                    <option value="{{ $brand->id_brands }}">{{ $brand->brands_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> --}}






    {{-- </div><!-- az-content-body --> --}}
@endsection

@push('scripts')
    <script type="text/javascript">
        function confirmDelete() {
            return confirm('Are you sure you want to delete this supplier?');
        }

        // <script type="text/javascript">
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Supplier List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });


        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('supplier/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });

        $(document).ready(function() {
            $('#brandModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var supplierId = button.data('id');
                var modal = $(this);
                modal.find('#supplier_id').val(supplierId);
            });
        });
    </script>
@endpush
