<?php

namespace App\Http\Controllers;

use App\ProductsCategory;
use App\Http\Controllers\Controller;
use App\ProductsSubCategory;
use Google\Cloud\Vision\V1\Product;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ProductsCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $product = ProductsCategory::all()
            //  $discounts = Discounts::all()
            ->join('users as u', 'u.id', 'po.created_by');
        $product = DB::table('products_category')
            ->join('users', 'users.id', 'products_category.created_by')
            ->select('products_category.*', 'users.name')->get();
        // dd($discounts);
        return view('product_category.index', compact('product'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $product = ProductsCategory::all();
        return view('product_category.create', compact('product'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $store = new ProductsCategory();
        $store->products_category_name = $request->products_category_name;
        $store->products_category_name_urdu = $request->products_category_name_urdu;
        $store->products_category_status = $request->products_category_status;
        // $store->products_category_status = "1";
        $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Product Category  Added Successfully");

        return redirect('product');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    // public function show()
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit = ProductsCategory::where('id_products_category', $dec_id)->first();
        // $edit = currency_exchange_rate::all();

        return view('product_category.edit', compact('edit'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $dec_id = \Crypt::decrypt($id);
        // dd($dec_id);
        $update = ProductsCategory::where('id_products_category', $dec_id)->first();
        $update->products_category_name = $request->products_category_name;
        $update->products_category_name_urdu = $request->products_category_name_urdu;
        $update->products_category_status = $request->products_category_status;

        // $update->products_category_status = "1";
        $update->created_by = auth()->user()->id;
        $update->save();
        session()->flash('info', "Product Category  Updated  Successfully");

        return redirect('product');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProductsCategory  $productsCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ProductssubCategory = ProductsSubCategory::where('products_category_id', $id)->get();
        // dd($ProductssubCategory);
        if ($ProductssubCategory) {

            session()->flash('info', "Product Category Has Sub Categories and cannot be deleted!");
            return redirect()->back();
        } else {
            $ProductsCategory = ProductsCategory::findOrFail($id);
            $ProductsCategory->delete();
            session()->flash('warning', "Product Category Removed!");
            return redirect()->back();
        }
    }


    public function product_sub_cat($id)
    {
        $product = ProductsCategory::findOrFail($id);
        $products_sub_cat = ProductsSubCategory::where('products_category_id', $product->id_products_category)
            ->where('prime', '=', '1')
            ->get();
        // $products_sub_cat2 = ProductsSubCategory::where('prime', '=', '1')->get();
        // dd($products_sub_cat);

        return view('product_category.product_sub_cat.product_sub_cat_index', compact('products_sub_cat', 'product'));
    }

    // public function product_sub_cat_create($id)
    // {
    //     // dd($id);
    //     $products_sub_cat = ProductsSubCategory::all();

    //     $product = ProductsCategory::findOrFail($id);
    //     return view('product_category.product_sub_cat.product_sub_cat_create', compact('products_sub_cat', 'product'));
    // }
    public function product_sub_cat_store(Request $request)
    {

        $store = new ProductsSubCategory();
        $store->products_category_id = $request->id_products_category;
        $store->name = $request->name;
        $store->name_urdu = $request->name_urdu;
        $store->prime = '1';
        $store->status = $request->status;
        // $store->products_category_status = "1";
        $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Product Sub Category  Added Successfully");

        return redirect()->back();
    }

    // public function product_sub_cat_edit($id)
    // {
    //     $products_sub_cat = ProductsSubCategory::all();
    //     $product = ProductsCategory::findOrFail($id);

    //     return view('product_category.product_sub_cat.product_sub_cat_edit', compact('products_sub_cat', 'product'));
    // }


    public function product_sub_cat_update(Request $request, $id)
    {
        $update = ProductsSubCategory::findOrFail($id);

        $update->products_category_id = $request->id_products_category;
        $update->name = $request->name;
        $update->name_urdu = $request->name_urdu;
        $update->status = $request->status;
        $update->created_by = auth()->user()->id;
        $update->save();
        // dd($update);
        session()->flash('success', "Product Sub Category Updated Successfully");

        // Redirect back to the previous page
        return redirect()->back();
    }

    public function product_sub_cat_destroy($id)
    {
        $subCategory = ProductsSubCategory::findOrFail($id);

        $hasSubSubCategories = ProductsSubCategory::where('sub_sub_pro_cat_id', $subCategory->id_pro_sub_cat)->exists();

        if ($hasSubSubCategories) {
            session()->flash('info', "Product Sub Category has Sub Categories and cannot be deleted!");
            return redirect()->back();
        }
        $subCategory->delete();
        session()->flash('warning', "Product Sub Category Removed!");

        return redirect()->back();
    }


    public function product_sub_sub_cat($p_id, $id)
    {
        $product = ProductsCategory::findOrFail($p_id);
        $currentSubCategory = ProductsSubCategory::findOrFail($id);

        $matchingId = $currentSubCategory->id_pro_sub_cat;

        $ProductsSubCategory = DB::table('products_sub_cat as psc1')
            ->join('products_sub_cat as psc2', 'psc1.sub_sub_pro_cat_id', '=', 'psc2.id_pro_sub_cat')
            ->select('psc1.*', 'psc2.name as sub_category_name')
            ->where('psc1.sub_sub_pro_cat_id', $matchingId)
            ->get()->toArray();

        // dd($ProductsSubCategory);

        return view('product_category.product_sub_sub_cat.product_sub_cat_index', compact('ProductsSubCategory', 'product', 'currentSubCategory'));
    }

    public function product_sub_sub_cat_store(Request $request)
    {

        $store = new ProductsSubCategory();
        $store->products_category_id = $request->id_products_category;
        $store->sub_sub_pro_cat_id = $request->id_pro_sub_cat;
        $store->name = $request->name;
        $store->name_urdu = $request->name_urdu;
        $store->prime = '0';
        $store->status = $request->status;
        // $store->products_category_status = "1";
        $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();
        session()->flash('success', "New Product Sub Category  Added Successfully");

        return redirect()->back();
    }
}
