@extends('layouts.master')

@section('content')

    <style>
        .iti.iti--allow-dropdown.iti--show-flags {
            width: 100%;
        }
    </style>
    <div class="az-content-breadcrumb">
        <span>Customer list</span>
        <span>Add Customer</span>
        {{-- <span>Forms</span> --}}
        {{-- <span>Form Layouts</span> --}}
    </div>
    <h2 class="az-content-title" style="display: inline">Add Customer <span>
            {{-- <a href="{{ url('customers') }}" class="btn btn-az-primary" style="float: right">Customer List
        </a> --}}
            <a href="{{ url('customers') }}" class="btn border" style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Customer
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Customer Details</h5>
                <form method="post" enctype="multipart/form-data" action="{{ url('customers/store') }}">
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">
                                    {{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Name (English)
                                    <span style="color:red;">*</span>
                                </label>
                                <input type="text" name="customer_name" class="form-control" required />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="" style="float: inline-end;">
                                    کھا تہ
                                </label>
                                <input type="text" name="customer_name_urdu" class="form-control" id="customer_name_urdu"
                                    dir="rtl" />
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group">
                                <label class="">
                                    Customer Email
                                    
                                </label>
                                <input type="text" name="customer_email" class="form-control" />
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ">
                                <label class="">
                                    Contact Number
                                    
                                </label>
                                <input type="text" id="whatsapp_number" class="form-control" name="customer_phone">
                                <div class="invalid-feedback1"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label class="">Contact - Other /
                                    PTCL / WHATSAPP</label>
                                <input type="text" class="form-control" name="customer_whatsapp">
                                <div class="invalid-feedback2"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Balance Dr
                                </label>
                                <input type="text" class="form-control" name="customer_ope_bal_dr">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Balance Cr
                                </label>
                                <input type="text" class="form-control" name="customer_ope_bal_cr">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">
                                    Opening Date
                                </label>
                                <input type="date" class="form-control" name="customer_ope_date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Address (English)
                                </label>
                                <input type="text" name="customer_address" class="form-control" />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="">
                                    Customer Address (Urdu)
                                </label>
                                <input type="text" name="customer_address_urdu" id="customer_address_urdu" dir="rtl"
                                    class="form-control" />
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Customer
                                    Reference</label>
                                <input type="text" class="form-control" name="customer_reference">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Remarks
                                    (English)</label>
                                <input type="text" class="form-control" name="customer_remarks">
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Remarks
                                    (Urdu)</label>
                                <input type="text" class="form-control" dir="rtl" id="customer_remarks_urdu"
                                    name="customer_remarks_urdu">
                            </div>
                        </div>
                    </div>

                    <div class="row my-3">
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Customer
                                    Image</label>
                                <input type="file" class="form-control" name="customer_image" />
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group ml-2 mt-2">
                                <label class="">Status</label>
                                <select class="form-control" name="customer_status" id="customer_status">
                                    <option value="1">Active</option>
                                    <option value="0">In Active</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="customer_records d-none"></div>
                    <div class="customer_records_dynamic"></div>
                    @csrf

                    <a href="{{ url('customers') }}" class="btn btn-danger btn-block mt-2">
                        Back
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        document.getElementById('customer_name_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        document.getElementById('customer_address_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        document.getElementById('customer_remarks_urdu').addEventListener('input', function(e) {
            var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
            var inputValue = e.target.value;

            e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        });

        $('.extra-fields-customer').click(function() {
            $('.customer_records').clone().appendTo('.customer_records_dynamic');
            $('.customer_records_dynamic .customer_records').addClass('single remove');
            $('.single .extra-fields-customer').remove();
            $('.single').append(
                '<a href="#" class="remove-field btn-remove-customer btn btn-danger">Remove Fields</a>');
            $('.customer_records_dynamic > .single').attr("class", "remove");

            $('.customer_records_dynamic input').each(function() {
                var count = 0;
                var fieldname = $(this).attr("name");
                $(this).attr('name', fieldname + count);
                count++;
            });

        });

        $(document).on('click', '.remove-field', function(e) {
            $(this).parent('.remove').remove();
            e.preventDefault();
        });
        // Ajax to get City
        $(document).ready(function() {

            $('#country-dropdown').on('change', function() {
                var country_id = this.value;
                // alert(country_id)
                $("#city-dropdown").html('');
                $.ajax({
                    url: "{{ url('get-cities-by-country') }}",
                    type: "POST",
                    data: {
                        country_id: country_id,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#city-dropdown').html(
                            '<option value="">Select City</option>');
                        $.each(result.cities, function(key, value) {
                            $("#city-dropdown").append('<option value="' +
                                value.id +
                                '">' + value.name + '</option>');
                        });
                    }
                });
            });
        });
    </script>

    <script>
        // Get Already Customer
        $("#phone0").on("keyup change", function(e) {
            let val = $(this).val();

            $.ajax({
                url: "{{ url('check_customer_number') }}/" + val,
                type: "GET",
                data: {
                    number: val
                },
                dataType: 'json',
                success: function(result) {
                    if (result.getCell == true) {
                        alert('Customer already exists!');

                    }
                }
            });
        })
    </script>
@endpush
