@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Paymet Voucher</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Paymet Voucher<span>

                <a href="{{ route('paymet.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Paymet Voucher</a>

        </span>
    </h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-10p">Pv#</th>
                            <th class="wd-10p">Invoice No</th>
                            <th class="wd-10p">Slip No</th>
                            <th class="wd-10p">From Account</th>
                            <th class="wd-10p">To Account</th>
                            <th class="wd-10p">Amount</th>
                            <th class="wd-10p">Remarks</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </thead>
                    {{-- <tbody>
                        @foreach ($voucher as $key => $sup)
                            <tr>

                                <td>{{ $key + 1 }}</td>
                                <td>{{ $sup->voucher_name }}</td>
                                <td>{{ $sup->voucher_email }}</td>
                                <td>{{ $sup->voucher_address }}</td>
                                <td>{{ $sup->contact_person }}</td>
                                <td>{{ $sup->phone_1 }}</td>
                                <td>{{ $sup->website }}</td>
                                <td>
                                    @if ($sup->status == 1)
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    @else
                                        <span class="btn btn-rounded btn-danger">In Active</span>
                                    @endif
                                </td>
                                <td><?= date('d-m-Y', strtotime($sup->created_at)) ?></td>

                                <td>
                                    @can('Journal Paymet Vouchers edit')
                                        <a class="btn btn-primary"
                                            href="{{ route('general.edit', \Crypt::encrypt($sup->id_voucher)) }}">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    @endcan
                                    @can('Journal Paymet Vouchers delete')
                                        <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                            data-id="{{ $sup->id_voucher }}">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody> --}}
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Date</th>
                            <th class="wd-10p">Pv#</th>
                            <th class="wd-10p">Invoice No</th>
                            <th class="wd-10p">Slip No</th>
                            <th class="wd-10p">From Account</th>
                            <th class="wd-10p">To Account</th>
                            <th class="wd-10p">Amount</th>
                            <th class="wd-10p">Remarks</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Paymet Voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>





    {{-- </div><!-- az-content-body --> --}}
@endsection

@push('scripts')
    <script>
        function confirmDelete() {
            return confirm('Are you sure you want to delete this Paymet voucher?');
        }

        // $(function() {
        //     oTable = $('#example2').DataTable({
        //         responsive: !0
        //     });
        // });

        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Paymet Voucher List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Paymet Voucher List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Paymet Voucher List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Paymet Voucher List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('paymet/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
