<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccountsPermissions extends Model
{
//    use HasFactory; // Don't forget to use the HasFactory trait

    protected $fillable = ['account_id', 'role_id', 'permission_id', 'is_enabled'];
    protected $table = 'accounts_permission';

    // Define the relationship with the Role model
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    // Define a method to fetch MainAccounts with nested accounts
    public function mainAccounts()
    {
        return MainAccount::with([
            'controlAccounts.subControlAccounts.transactionAccounts'
        ])->get();
    }
}
