<?php

namespace App\Http\Controllers;

use App\ChartOfAccount;
// use App\control_account;
use App\ControlAccount;
// use App\main_account;
use App\MainAccount;
// use App\Sub_control_account;
use App\SubControlAccount;
// use App\transaction_account;
use App\TransactionAccount;
use Illuminate\Http\Request;

class ChartOfAccountController extends Controller
{

    public function main_account()
    {
        $main_account = MainAccount::all();
        return view('chart_of_account.main_account', compact('main_account'));
    }

    public function main_account_store(Request $request)
    {
        $request->validate([
            'name' => 'string|max:255',
            'a_urdu_name' => 'nullable|string|max:255',
        ]);
        $lastMainAccount = MainAccount::orderBy('id_main_account', 'desc')->first();

        $newAccountNumber = $lastMainAccount ? sprintf('%02d', $lastMainAccount->main_account_number + 1) : '1';

        $store = new MainAccount();
        $store->main_account_number = $newAccountNumber;
        $store->main_account_name = $request->name;
        $store->a_urdu_name = $request->a_urdu_name;
        $store->save();
        return redirect()->back()->with('success', 'Main Account added successfully!');
    }


    public function control_account($id)
    {
        $main_account = MainAccount::findOrFail($id);
        // dd($main_account->main_account_name);
        $control_account = ControlAccount::where('main_account_id', $main_account->id_main_account)
            ->get();
        // $main_account2 = main_account::select('main_account_name')
        //     ->whereIn('id_main_account', $control_account->pluck('main_account_id')->toArray())
        //     ->get();
        // dd($main_account2);

        return view('chart_of_account.control_account', compact('control_account', 'main_account'));
    }

    public function control_account_store(Request $request)
    {
        $request->validate([
            'name' => 'string|max:255',
            'ca_urdu_name' => 'nullable|string|max:255',
        ]);
        $lastMainAccount = ControlAccount::where('main_account_id', $request->id_main_account)
            ->orderBy('id_control_account', 'desc')->first();

        $newAccountNumber = $lastMainAccount ? sprintf('%02d', $lastMainAccount->control_account_number + 1) : '1';

        $store = new ControlAccount();
        $store->main_account_id = $request->id_main_account;
        $store->control_account_number = $newAccountNumber;
        $store->control_account_name = $request->name;
        $store->ca_urdu_name = $request->ca_urdu_name;
        // dd($store);
        $store->save();

        return redirect()->back()->with('success', 'Main Account added successfully!');
    }

    public function control_account_update(Request $request, $id)
    {

        $update = ControlAccount::where('id_control_account', $id)->first();
        $update->control_account_name = $request->name;
        $update->ca_urdu_name = $request->ca_urdu_name;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Sub Control Account Updated successfully!');
    }



    public function sub_control_account($c_id, $id)
    {

        $main_account = MainAccount::findOrFail($c_id);
        // dd($main_account);
        $control_account = ControlAccount::where('main_account_id', $main_account->id_main_account)
            ->where('id_control_account', $id)
            ->firstOrFail();
        // dd($control_account->control_account_name);
        $sub_control_accounts = SubControlAccount::where('control_account_id', $control_account->id_control_account)
            ->get();

        // dd($sub_control_accounts);

        return view('chart_of_account.sub_control_account', compact('sub_control_accounts', 'control_account', 'main_account'));
    }

    public function sub_control_account_store(Request $request)
    {
        $request->validate([
            'name' => 'string|max:255',
            'sca_urdu_name' => 'nullable|string|max:255',
        ]);
        $lastSubControlAccount = SubControlAccount::where('control_account_id', $request->id_control_account)
            ->orderBy('id_sub_control_account', 'desc')
            ->first();

        $newAccountNumber = $lastSubControlAccount ? sprintf('%02d', $lastSubControlAccount->sub_control_account_number + 1) : '1';

        $store = new SubControlAccount();
        $store->control_account_id = $request->id_control_account;
        $store->sub_control_account_number = $newAccountNumber;
        $store->sub_control_account_name = $request->name;
        $store->sca_urdu_name = $request->sca_urdu_name;
        $store->save();

        return redirect()->back()->with('success', 'Sub Control Account added successfully!');
    }

    public function sub_control_account_update(Request $request, $id)
    {

        $update = SubControlAccount::where('id_sub_control_account', $id)->first();
        $update->sub_control_account_name = $request->name;
        $update->sca_urdu_name = $request->sca_urdu_name;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Sub Control Account Updated successfully!');
    }

    public function destroy_sub_control_account($id)
    {
        $transactionAccount = TransactionAccount::where('sub_control_account_id', $id)->get();

        if ($transactionAccount->isEmpty()) {
            $subControlAccount = SubControlAccount::findOrFail($id);
            $subControlAccount->delete();

            return redirect()->back()->with('success', 'Sub Control Account deleted successfully!');
        } else {
            return redirect()->back()->with('warning', 'Sub Control Account has Transaction accounts!');
        }
    }

    public function transaction_account($c_id, $sc_id,  $id)
    {

        $main_account = MainAccount::findOrFail($c_id);
        // dd($main_account);
        $control_account = ControlAccount::findOrFail($sc_id);
        $sub_control_account = SubControlAccount::findOrFail($id);

        // dd($sub_control_account);
        $transaction_account = TransactionAccount::where('sub_control_account_id', $sub_control_account->id_sub_control_account)
            ->get();

        return view('chart_of_account.transaction_account', compact('transaction_account', 'sub_control_account', 'control_account', 'main_account'));
    }



    public function transaction_account_store(Request $request)
    {
        $request->validate([
            'name' => 'string|max:255',
            'tacc_urdu_name' => 'nullable|string|max:255',
            'status' => 'nullable|string|max:255',
            'acc_type' => 'nullable|string|max:255',
        ]);
        $lastSubControlAccount = TransactionAccount::orderBy('transaction_account_number', 'desc')->first();

        $newAccountNumber = $lastSubControlAccount ? sprintf('%02d', $lastSubControlAccount->transaction_account_number + 1) : '1';
        $store = new TransactionAccount();
        $store->sub_control_account_id = $request->id_sub_control_account;
        $store->transaction_account_number = $newAccountNumber;
        $store->transaction_account_name = $request->name;
        $store->tacc_urdu_name = $request->tacc_urdu_name;
        $store->status = $request->status;
        $store->account_type = $request->acc_type;
        // dd($store);

        $store->save();



        return redirect()->back()->with('success', 'Transaction Account Updated successfully!');
    }

    public function transaction_account_update(Request $request, $id)
    {

        $update = TransactionAccount::where('id_transaction_account', $id)->first();
        $update->transaction_account_name = $request->name;
        $update->tacc_urdu_name = $request->tacc_urdu_name;
        $update->status = $request->status;
        $update->account_type = $request->account_type;
        // dd($update);

        $update->save();

        return redirect()->back()->with('success', 'Main Account added successfully!');
    }
    public function destroy_transaction_account($id)
    {

        $transaction_account = TransactionAccount::findOrFail($id);
        $transaction_account->delete();

        return redirect()->back()->with('success', 'Transaction Account deleted successfully!');
    }
}
