<?php

namespace App\Http\Controllers;

use App\AccountsPermissions;
use App\ControlAccount;
use App\MainAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\role_permission;
use App\SubControlAccount;
use App\TransactionAccount;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    protected $role_id;
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //     $this->middleware(function ($request, $next) {
    //         $this->role_id = Auth::user()->role_id;
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //         $ex = explode('/', $request->path());
    //         if (count($ex) >= 3) {
    //             $sliced = array_slice($ex, 0, -1);
    //         } else {
    //             $sliced = $ex;
    //         }

    //         $string = implode("/", $sliced);
    //         //                 dd($string);
    //         if (checkConstructor($this->role_id, count($ex) >= 3 ? $string . '/' : $string) == 1) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'store') !== false) {
    //             return $next($request);
    //         } else if (strpos($request->path(), 'update') !== false) {
    //             return $next($request);
    //         } else {
    //             abort(404);
    //         }
    //     });
    // }

    // public function index()
    // {
    //     $title = 'Permission';
    //     $menu = 'permission';
    //     $submenu = 'permission';
    //     $page = 'list';
    //     $roles = DB::table('roles')->get()->toArray();

    //     $permission = DB::table('role_permission')->where('role_id', request('id'))->pluck('menu_id')->toArray();

    //     $role_id = request('id') > 0 ? request('id') : 0;

    //     return view('Permission.index')->with(compact('title', 'menu','submenu', 'page', 'roles','role_id', 'permission'));
    // }

    public function index(Request $request)
    {
        $roles = Role::all();
        $role_id = $request->id ?? 0;

        // Fetch all permissions
        $permissions = Permission::all();
        $mainAccounts = MainAccount::with([
            'controlAccounts.subControlAccounts.transactionAccounts'
        ])->get();

        $enabled_accounts = AccountsPermissions::where('role_id', $role_id)
            ->where('is_enabled', '0')
            ->pluck('account_id')
            ->toArray();

        $assigned_permissions = $role_id ? Role::find($role_id)->permissions->pluck('id')->toArray() : [];

        return view('Permission.index', compact('enabled_accounts', 'roles', 'role_id', 'permissions', 'assigned_permissions', 'mainAccounts'));
    }

    public function toggleTransactionAccountStatus(Request $request)
    {
        $transactionAccount = TransactionAccount::find($request->id);
        $transactionAccount->status = $request->status; // Assuming you have a 'status' column
        $transactionAccount->save();

        return response()->json(['message' => 'Status updated successfully']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'Roles';

        $menu = 'role';
        $submenu = 'role';
        $page = 'add';

        return view('Roles.create')->with(compact('title', 'menu', 'submenu', 'page'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    // public function store(Request $request)
    // {
    //     //echo "<pre>";
    //     //print_r($request);exit;
    //     DB::table('role_permission')->where('role_id', request('id'))->delete();
    //     if($request->menu_id){
    //         for($i = 0; $i < count($request->menu_id); $i++){
    //             DB::table('role_permission')
    //             ->insert(['role_id' => request('id'), 'menu_id' => $request->menu_id[$i]]);
    //         }
    //     }
    //     return back();
    // }

    public function store(Request $request, $role_id)
    {
        // Validate the request
        $validated = $request->validate([
            'permissions' => 'array',
            'permissions.*' => 'integer|exists:permissions,id',
        ]);

        $role = Role::find($role_id);

        if ($role) {
            // Sync the role's permissions with the selected permissions
            $role->syncPermissions($validated['permissions']);

            // Return success response
            return redirect()->back()->with('alert', 'Permissions updated successfully')->with('alert-class', 'success');
        }

        // Handle case where role is not found
        return redirect()->back()->with('alert', 'Role not found')->with('alert-class', 'danger');
    }

    // public function accindex(Request $request)
    // {
    //     $roles = Role::all();
    //     $role_id = $request->id ?? 0;

    //     // Fetch all permissions
    //     $permissions = Permission::all();
    //     $mainAccounts = MainAccount::with([
    //         'controlAccounts.subControlAccounts.transactionAccounts'
    //     ])->get();
    //     $assigned_permissions = $role_id ? Role::find($role_id)->permissions->pluck('id')->toArray() : [];

    //     return view('Permission.accindex', compact('roles', 'role_id', 'permissions', 'assigned_permissions', 'mainAccounts'));
    // }
    // public function accstore(Request $request, $role_id)
    // {
    //     // Validate the request
    //     $validated = $request->validate([
    //         'permissions' => 'array',
    //         'permissions.*' => 'integer|exists:permissions,id',
    //     ]);
    //     dd($request);

    //     $role = Role::find($role_id);

    //     if ($role) {
    //         // Sync the role's permissions with the selected permissions
    //         $role->syncPermissions($validated['permissions']);

    //         // Return success response
    //         return redirect()->back()->with('alert', 'Permissions updated successfully')->with('alert-class', 'success');
    //     }

    //     // Handle case where role is not found
    //     return redirect()->back()->with('alert', 'Role not found')->with('alert-class', 'danger');
    // }
    // public function accstore(Request $request, $role_id)
    // {
    //     $validated = $request->validate([
    //         'accounts' => 'nullable|array', // Allow nullable for accounts
    //         'accounts.*.account_id' => 'required|integer', // Ensure the account_id is an integer
    //     ]);


    //     // Find the role by its ID
    //     $role = Role::find($role_id);

    //     if ($role) {
    //         $permissionsToSave = [];

    //         // Loop through the validated accounts and prepare the data for saving
    //         if (isset($validated['accounts'])) {
    //             foreach ($validated['accounts'] as $account) {
    //                 $permissionsToSave[] = [
    //                     'role_id' => $role_id,
    //                     'account_id' => $account['account_id'], // Get the account ID from the form
    //                     'permission' => 'some_permission_value', // Adjust this value based on your logic
    //                 ];
    //             }
    //         }

    //         // After debugging, insert the accounts and permissions
    //         if (!empty($permissionsToSave)) {
    //             dd($permissionsToSave);
    //             // Optionally, delete existing permissions for the role before inserting new ones
    //             AccountsPermissions::where('role_id', $role_id)->delete(); // Clear previous permissions for this role
    //             AccountsPermissions::insert($permissionsToSave); // Save new permissions
    //         }

    //         // Redirect back with a success message
    //         return redirect()->back()->with('alert', 'Permissions updated successfully')->with('alert-class', 'success');
    //     }

    //     // If role not found, return an error
    //     return redirect()->back()->with('alert', 'Role not found')->with('alert-class', 'danger');
    // }
//     public function accstore(Request $request, $role_id)
// {
//     // Validate the incoming request
//     $validated = $request->validate([
//         'accounts' => 'nullable|array', // Allow nullable for accounts
//         'accounts.*.account_id' => 'required|integer', // Ensure the account_id is an integer
//     ]);

//     // Find the role by its ID
//     $role = Role::find($role_id);

//     // Check if the role exists
//     if (!$role) {
//         return redirect()->back()->with('alert', 'Role not found')->with('alert-class', 'danger');
//     }

//     $permissionsToSave = [];

//     // Loop through the validated accounts and prepare the data for saving
//     if (isset($validated['accounts'])) {
//         foreach ($validated['accounts'] as $account) {
//             // Fetch the account name based on the account_id
//             $accountName = '';
//             if ($mainAccount = MainAccount::find($account['account_id'])) {
//                 $accountName = $mainAccount->main_account_name;
//             } elseif ($controlAccount = ControlAccount::find($account['account_id'])) {
//                 $accountName = $controlAccount->control_account_name;
//             } elseif ($subControlAccount = SubControlAccount::find($account['account_id'])) {
//                 $accountName = $subControlAccount->sub_control_account_name;
//             } elseif ($transactionAccount = TransactionAccount::find($account['account_id'])) {
//                 $accountName = $transactionAccount->transaction_account_name;
//             }

//             // Debugging: Check if accountName was found
//             if (!$accountName) {
//                 \Log::error('Account name not found for account_id: ' . $account['account_id']);
//                 continue; // Skip this account if not found
//             }

//             // Prepare the data for saving
//             $permissionsToSave[] = [
//                 'role_id' => $role_id,
//                 'account_id' => $account['account_id'],
//                 'permission' => 'some_permission_value', // Adjust this value based on your logic
//                 'account_name' => $accountName, // Add the account name to the permissions
//             ];
//         }
//     }

//     // Debugging: Check what will be saved
//     \Log::info('Permissions to save:', $permissionsToSave);

//     // After debugging, insert the accounts and permissions
//     if (!empty($permissionsToSave)) {
//         // Optionally, delete existing permissions for the role before inserting new ones
//         AccountsPermissions::where('role_id', $role_id)->delete(); // Clear previous permissions for this role
//         AccountsPermissions::insert($permissionsToSave); // Save new permissions

//         // Redirect back with a success message
//         return redirect()->back()->with('alert', 'Permissions updated successfully')->with('alert-class', 'success');
//     }

//     // Redirect back with a message if no permissions were saved
//     return redirect()->back()->with('alert', 'No permissions were updated')->with('alert-class', 'warning');
// }
public function accstore(Request $request, $role_id)
{
    // Validate the incoming request
    $validated = $request->validate([
        'accounts' => 'nullable|array', // Allow nullable for accounts
        'accounts.*.account_id' => 'required|integer', // Ensure the account_id is an integer
    ]);

    // Find the role by its ID
    $role = Role::find($role_id);

    // Check if the role exists
    if (!$role) {
        return redirect()->back()->with('alert', 'Role not found')->with('alert-class', 'danger');
    }

    // Prepare an array to hold permissions to save
    $permissionsToSave = [];

    // Loop through the validated accounts and prepare the data for saving
    if (isset($validated['accounts'])) {
        foreach ($validated['accounts'] as $account) {
            $accountId = $account['account_id'];
            // Initialize all account ID variables to null
            $mainAccountId = $controlAccountId = $subControlAccountId = $transactionAccountId = null;
            $accountName = null;
            $accountType = null;

            // Determine the account type and fetch the account name accordingly
            if ($mainAccount = MainAccount::find($accountId)) {
                $accountName = $mainAccount->main_account_name;
                $mainAccountId = $mainAccount->id_main_account;
                $accountType = 'MainAccount';
            } elseif ($controlAccount = ControlAccount::find($accountId)) {
                $accountName = $controlAccount->control_account_name;
                $controlAccountId = $controlAccount->id_control_account;
                $accountType = 'ControlAccount';
            } elseif ($subControlAccount = SubControlAccount::find($accountId)) {
                $accountName = $subControlAccount->sub_control_account_name;
                $subControlAccountId = $subControlAccount->id_sub_control_account;
                $accountType = 'SubControlAccount';
            } elseif ($transactionAccount = TransactionAccount::find($accountId)) {
                $accountName = $transactionAccount->transaction_account_name;
                $transactionAccountId = $transactionAccount->id_transaction_account;
                $accountType = 'TransactionAccount';
            } else {
                // Skip if account ID does not match any account type
                \Log::error('Invalid account ID: ' . $accountId);
                continue; // Skip this iteration
            }

            // Prepare the permission entry with the new structure
            $permissionsToSave[] = [
                'role_id' => $role_id,
                'account_id' => $accountId,
                'account_name' => $accountName, // Store the account name for reference
                'account_type' => $accountType, // Store account type if needed
                'main_account_id' => $mainAccountId,
                'control_account_id' => $controlAccountId,
                'sub_control_account_id' => $subControlAccountId,
                'transaction_account_id' => $transactionAccountId,
            ];
        }
    }

    // Debugging: Check what will be saved
    \Log::info('Permissions to save:', $permissionsToSave);

    // Optionally, delete existing permissions for the role before inserting new ones
    AccountsPermissions::where('role_id', $role_id)->delete(); // Clear previous permissions for this role

    // Save new permissions if there are any
    if (!empty($permissionsToSave)) {
        AccountsPermissions::insert($permissionsToSave); // Save new permissions

        // Redirect back with a success message
        return redirect()->back()->with('alert', 'Permissions updated successfully')->with('alert-class', 'success');
    }

    // Redirect back with a message if no permissions were saved
    return redirect()->back()->with('alert', 'No permissions were updated')->with('alert-class', 'warning');
}





    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = 'Roles';
        $menu = 'role';
        $submenu = 'role';
        $page = 'edit';
        $role = DB::table('roles')->where('id_roles', $id)->first();

        return view('Roles.edit')->with(compact('title', 'menu', 'submenu', 'page', 'role'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'role' => 'required',
        ]);

        DB::table('roles')->where('id_roles', $id)->update(['role' => $request->role, 'updated_at' => date('Y-m-d H:i:s')]);

        return redirect(url('roles'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $role = DB::table('roles')->where('id_roles', $request->id)->delete();
        Session::flash('message', 'Role has been deleted');
        return back();
    }
}
