<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductsSubCategoryChild extends Model
{
    protected $table = 'products_sub_cat_child';
    protected $primaryKey = 'id_pro_sub_cat_child';
    protected $fillable = [
        'pro_sub_cat_parent_id',
        'name',
        'name_urdu',
        'status',
        'created_by',
    ];

    // A child sub-category belongs to a parent sub-category
    public function parentCategory()
    {
        return $this->belongsTo(ProductsSubCategoryParent::class, 'pro_sub_cat_parent_id', 'id_pro_sub_cat_parent');
    }
}
