 @extends('layouts.master')
 @section('content')
     <div class="az-content-breadcrumb">
         <span>Brands & Products</span>
         <span>Add Brand</span>
     </div>
     <h2 class="az-content-title" style="display: inline">
         Add New Brand
         <span>
             <a href="{{ route('brands.list') }}" class="btn border" style="float: right"><i
                     class="fa-solid fa-bars-staggered"></i>
                 Back to Brands
             </a>
         </span>
     </h2>
     <div class="separator-breadcrumb border-top"></div>
     <div class="row">
         <div class="col-md-12 col-lg-12 col-xl-12">
             <div class="card card-body pd-40">
                 <h5 class="card-title mg-b-20">Insert Brand Details</h5>
                 @if (Session('alert'))
                     <div class="alert alert-card alert-<?php echo Session('alert-class'); ?>" role="alert">
                         <?php echo Session('alert'); ?>
                         <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span
                                 aria-hidden="true">&times;</span></button>
                     </div>
                 @endif
                 <form action="{{ route('brand.store') }}" method="post" enctype="multipart/form-data">
                     @csrf
                     @if (count($errors) > 0)
                         <div class="p-1">
                             @foreach ($errors->all() as $error)
                                 <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                         <span aria-hidden="true">&times;</span>
                                     </button>
                                 </div>
                             @endforeach
                         </div>
                     @endif
                     <div class="row">
                         <div class="col-md-4">
                             <div class="row-sm mg-b-20">
                                 <div class="form-group">
                                     <label class="az-content-label tx-11 tx-medium tx-gray-600">Brand Name <span
                                             style="color:red;">*</span></label>
                                     <input name="brand_name" id="brand_name" class="form-control"
                                         value="{{ old('brand_name') }}" />
                                     @error('brand_name')
                                         <span class="form-text text-muted">
                                             <strong>{{ $message }}</strong>
                                         </span>
                                     @enderror
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="row-sm mg-b-20">
                                 <div class="form-group">
                                     <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                         for="brands_abbrevation">Brands Abbrevation</label>
                                     <input name="brands_abbrevation" id="brands_abbrevation" class="form-control"
                                         value="{{ old('brands_abbrevation') }}" />
                                     @error('brands_abbrevation')
                                         <span class="form-text text-muted">
                                             <strong>{{ $message }}</strong>
                                         </span>
                                     @enderror
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="row-sm mg-b-20">
                                 <div class="form-group">
                                     <label class="az-content-label tx-11 tx-medium tx-gray-600" for="supplier_id">Suppliers
                                         <span style="color:red;">*</span></label>
                                     <select id="supplier_id" name="supplier_id" class="form-control">
                                         <option value="">Select Supplier</option>
                                         @foreach ($suppliers as $supplier)
                                             <option value="{{ $supplier->id_supplier }}"
                                                 {{ old('supplier_id') == $supplier->id_supplier ? 'selected' : '' }}>
                                                 {{ $supplier->supplier_name }}
                                             </option>
                                         @endforeach
                                     </select>
                                     @error('supplier_id')
                                         <span class="form-text text-muted">
                                             <strong>{{ $message }}</strong>
                                         </span>
                                     @enderror
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="row-sm mg-b-20">
                                 <div class="form-group">
                                     <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                         for="brands_status">Status</label>
                                     <select id="brands_status" name="brands_status" class="form-control">
                                         <option value="">Select</option>
                                         <option value="1" {{ old('brands_status') == '1' ? 'selected' : '' }} selected>Active
                                         </option>
                                         <option value="0" {{ old('brands_status') == '0' ? 'selected' : '' }}>
                                             Inactive</option>
                                     </select>
                                     @error('brands_status')
                                         <span class="form-text text-muted">
                                             <strong>{{ $message }}</strong>
                                         </span>
                                     @enderror
                                 </div>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="row-sm mg-b-20">
                                 <div class="form-group">
                                     <label class="az-content-label tx-11 tx-medium tx-gray-600">Brand Logo</label>
                                     <input type="file" name="brand_logo" id="brand_logo" class="form-control" />
                                     @error('brand_logo')
                                         <span class="form-text text-muted">
                                             <strong>{{ $message }}</strong>
                                         </span>
                                     @enderror
                                 </div>
                             </div>
                         </div>
                     </div>

                     <button type="button" onclick="history.back()" class="btn btn-danger btn-block mt-2">Cancel</button>
                     <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Submit</button>
                 </form>
             </div>
         </div>
     </div>
     <script src="https://cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
 @endsection
