@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Service Purchase Voucher</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Service Purchase Voucher<span>

            <a href="{{ route('service_voucher.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Service Purchase Voucher</a>

        </span>
    </h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    {{-- <table id="example2" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">S.No</th>
                                            <th class="wd-10p">Created Date</th>
                                            <th class="wd-10p">Debit</th>
                                            <th class="wd-10p">Credit</th>
                                            <th class="wd-10p">Business Partner</th>
                                            <th class="wd-10p">Payment Mode</th>
                                            <th class="wd-10p">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($vouchersNumber as $vouchersUnique)
                                            <tr class="group group-start">
                                                <td colspan="7">
                                                    {{ $vouchersUnique->voucher_number }}
                                                </td>
                                            </tr>
                                            @foreach ($vouchersUnique->vouchers as $key => $voucher)
                                                <tr role="row">
                                                    <td>{{ $key + 1 }}</td>
                                                    <td>{{ date('d-m-Y', strtotime($voucher->date)) }}</td>
                                                    <td>{{ $voucher->debit }}</td>
                                                    <td>{{ $voucher->credit }}</td>
                                                    <td>{{ $voucher->partner_name }}</td>
                                                    <td>{{ $voucher->payment_mode }}</td>
                                                    <td>
                                                        @can('Journal Journal Vouchers edit')
                                                            <a class="btn btn-primary"
                                                                href="{{ route('voucher.edit', \Crypt::encrypt($voucher->id_vouchers)) }}">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                        @endcan
                                                        @can('Journal Journal Vouchers delete')
                                                            <a href="#" class="btn btn-danger" data-toggle="modal"
                                                                data-target="#deleteModal" data-id="{{ $voucher->id_vouchers }}">
                                                                <i class="fas fa-trash"></i>
                                                            </a>
                                                        @endcan
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                </table> --}}

                    {{-- <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Voucher Number</th>
                                <th class="none">Expand Vouuchers</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($vouchersNumber as $vouchersUnique)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $vouchersUnique->voucher_number }}</td>
                                    <td>
                                        <table class="table table-bordered">
                                            <tr>
                                                <th>#</th>
                                                <th>Created Date</th>
                                                <th>Debit</th>
                                                <th>Credit</th>
                                                <th>Business Partner</th>
                                                <th>Payment Mode</th>
                                            </tr>
                                            @foreach ($vouchersUnique->vouchers as $key => $voucher)
                                                <tr>
                                                    <td>{{ $key + 1 }}</td>
                                                    <td>{{ date('d-m-Y', strtotime($voucher->date)) }}</td>
                                                    <td>{{ $voucher->debit }}</td>
                                                    <td>{{ $voucher->credit }}</td>
                                                    <td>{{ $voucher->partner_name }}</td>
                                                    <td>{{ $voucher->payment_mode }}</td>
                                                </tr>
                                            @endforeach
                                        </table>
                                    </td>
                                    <td>


                                        <a class="btn rounded shadow-base" title="View Journal Voucher"
                                            href="{{ route('voucher.s_view', \Crypt::encrypt($vouchersUnique->id_vouchers_unique_number)) }}">
                                            <i class="text-success fa-solid fa-eye"></i>
                                            <span class="text-success">View</span>
                                        </a>

                                        <a class="btn rounded shadow-base" title="Delete Journal Voucher"
                                            data-toggle="modal" data-target="#deleteModal"
                                            data-id="{{ Crypt::encrypt($vouchersUnique->id_vouchers_unique_number) }}">
                                            <i class="text-danger fa-solid fa-trash-can"></i>
                                            <span class="text-danger">Remove</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>S.No</th>
                                <th>Voucher Number</th>
                                <th class="none">Expand Vouuchers</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table> --}}
                    <table id="example23" class="display nowrap" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>created date</th>
                                <!-- <th>Description</th> -->
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Account Name</th>
                                <th>Business Partner Type</th>
                                <th>Business Partner</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>created date</th>
                                <!-- <th>Description</th> -->
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Account Name</th>
                                <th>Business Partner Type</th>
                                <th>Business Partner</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>

                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // $(document).ready(function() {
        //     $('#example2').DataTable({
        //         dom: 'Bfrtip',
        //         buttons: [{
        //                 extend: 'csv',
        //                 text: 'CSV',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'excel',
        //                 text: 'Excel',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'pdf',
        //                 text: 'PDF',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             },
        //             {
        //                 extend: 'print',
        //                 text: 'Print',
        //                 title: 'Journal Voucher List',
        //                 className: 'btn btn-default',
        //                 exportOptions: {
        //                     columns: 'th:not(:last-child)'
        //                 }
        //             }
        //         ],
        //         responsive: true
        //     });

        //     $('#deleteModal').on('show.bs.modal', function(event) {
        //         var button = $(event.relatedTarget);
        //         var id = button.data('id');
        //         var actionUrl = '{{ url('voucher/destroy') }}/' + id;
        //         var modal = $(this);
        //         modal.find('#deleteForm').attr('action', actionUrl);
        //     });
        // });

        $(document).ready(function() {
            var id = 0;
            oTable = $('#example23').DataTable({
                "stateSave": true,
                "processing": true,
                "serverSide": true,
                ajax: {
                    url: "{{ route('servicevoucherlisting') }}",
                    data: function(d) {
                        d._token = '{{ csrf_token() }}';
                        d.id = id;
                    }
                },
                "columns": [{
                        data: 'voucher_date',
                        name: 'created_at'
                    },
                    {
                        data: 'debit',
                        name: 'debit'
                    },
                    {
                        data: 'credit',
                        name: 'credit'
                    },
                    {
                        data: 'transaction_account_name',
                        name: 'transaction_acc_name' // Ensure this matches your returned data
                    },
                    {
                        data: 'bp_type',
                        name: 'business_partner_type'
                    },
                    {
                        data: 'bp_name',
                        name: 'partner_name'
                    },
                    {
                        data: 'action',
                        name: 'action'
                    }
                ],
                columnDefs: [{
                    targets: 0,
                    render: function(data) {
                        return moment(data).format('D MMMM YYYY');
                    }
                }],
                rowGroup: {
                    dataSrc: 'voucher_number'
                },
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                initComplete: function() {
                    this.api().columns([0, 3, 4, 5]).every(function() {
                        var column = this;
                        var input = document.createElement("input");
                        $(input).addClass('form-control input-sm');
                        $(input).appendTo($(column.footer()).empty())
                            .on('keyup', function() {
                                column.search($(this).val(), false, false, true).draw();
                            });
                    });
                },
            });
        });
    </script>
@endpush
