@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Measurement Unit</span>
        <span>Add Measurement Unit</span>

    </div>
    <h2 class="az-content-title" style="display: inline">Add New Measurement Unit <span>
        {{-- <a href="{{ url('measurement_unit') }}"
                class="btn btn-az-primary" style="float: right">Measurement Unit List</a></span> --}}

                <a href="{{ url('measurement_unit') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Measurement
            </a>
            </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Measurement Unit</h5>
                <form method="post" id="myForm" action="{{ url('measurement_unit/store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Measurement Unit Name <span style="color:red;">*</span></label>
                                <input type="text" name="measurement_unit_name" class="form-control" value="{{ old('measurement_unit_name') }}" required />
                            </div>
                            @error('measurement_unit_name')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                            <select class="form-control" name="measurement_unit_status" id="measurement_unit_status">
                                <option value="1">Active</option>
                                <option value="0">In Active</option>
                            </select>
                        </div>

                    </div>

                    <a type="button" href="{{ url('/measurement_unit') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


@endsection
@push('scripts')
<script>
    document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
</script>

@endpush
