@extends('layouts.master')

@section('content')
    <!-- ===== Page-Content ===== -->
    <!-- .row -->
    <div class="row">
        <div class="col-md-12">
            <div class="card p-3">
                <h3 class="box-title pull-left">Profit & Loss</h3>
                <div class="clearfix"></div>
                <hr>



                <form class="form-horizontal" method="POST" action="{{ route('profit_loss_report') }}">
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-10">

                            <div class="portlet light">
                                <div class="forms-horizontal form-body">
                                    <fieldset>

                                        <div class="form-group">

                                            <label for="fromdate" class="col-md-2 control-label">From Date</label>
                                            <div class="col-md-4">
                                                <div class="input-group mydatepicker date date-picker margin-bottom-5"
                                                    data-date-format="dd-mm-yyyy">
                                                    <input type="text" id="fromdate" autocomplete="off"
                                                        class="form-control form-filter" name="fromdate" required
                                                        placeholder="From" value="<?php if (isset($from_date)) {
                                                            echo date('m/d/Y', strtotime($from_date));
                                                        } ?>">

                                                </div>

                                            </div>

                                            <label for="todate" class="col-md-2 control-label">To Date</label>
                                            <div class="col-md-4">
                                                <div class="input-group mydatepicker date date-picker"
                                                    data-date-format="dd-mm-yyyy">
                                                    <input type="text" id="todate" autocomplete="off"
                                                        class="form-control form-filter" name="date_to" required
                                                        placeholder="To" value="<?php if (isset($to_date)) {
                                                            echo date('m/d/Y', strtotime($to_date));
                                                        } ?>">

                                                </div>

                                            </div>

                                        </div>

                                    </fieldset>
                                </div>
                            </div>

                        </div>

                        <div class="col-md-2">
                            <div class="portlet light">
                                <div class="portlet-body">
                                    <div class="form-horizontal form-body">
                                        <div style="text-align: left;">
                                            <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i>
                                                Run
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </form>


            </div>
        </div>
    </div>


    <!-- ===== Table for Result ===== -->
    <?php if(isset($sales)): ?>
    <div class="printableArea mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card p-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <h3 class="box-title mb-0">Profit & Loss:</h3>
                            <h3 class="box-title mb-0" style="margin-left: 20px;">
                                From: <span id="fdate">
                                    <?php if (isset($from_date)) {
                                        echo date('d-m-Y', strtotime($from_date));
                                    } ?>
                                </span>
                                To: <span id="tdate">
                                    <?php if (isset($to_date)) {
                                        echo date('d-m-Y', strtotime($to_date));
                                    } ?>
                                </span>
                            </h3>
                        </div>
                        <div>
                            <button type="button" class="btn btn-secondary btn-sm" id="print">
                                <i class="fa fa-print"></i> Print
                            </button>
                        </div>
                    </div>


                    <div class="clearfix"></div>
                    <hr>

                    <!-- Revenue  table statrs -->
                    <?php $net_sale = 0;
                    $gross_profit = 0;
                    $total_income = 0;
                    $vendor_expanse = 0;
                    $other_expanse = 0;
                    $total_admin_expanses = 0; ?>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light">
                                <h2>Revenue</h2>
                                <table style="width: 85%;" align="right">
                                    <?php $gross_sales = 0; ?>
                                    @foreach ($sales as $sale)
                                        <tr>
                                            <td style="width: 70%;text-align: left;padding: 4px;">
                                                {{ $sale->transaction_account_name }}</td>
                                            <td style="width: 30%;text-align: right;padding: 4px;">
                                                {{ number_format($sale->balance, 2) }}</td>
                                            <?php $gross_sales += $sale->balance; ?>
                                        </tr>
                                    @endforeach

                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">Gross
                                            Sales</td>
                                        <td style="width: 30%;text-align: right;padding: 4px;font-weight: bold;">
                                            {{ number_format($gross_sales, 2) }}</td>
                                    </tr>
                                    <?php $salesreturn = 0; ?>
                                    @foreach ($sales_return as $return)
                                        <?php $salesreturn += $return->balance; ?>
                                    @endforeach
                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;">Sales Return</td>
                                        <td style="width: 30%;text-align: right;padding: 4px;">
                                            {{ number_format($salesreturn, 2) }}</td>
                                    </tr>
                                    <?php $discounts = 0; ?>
                                    @foreach ($sales_discount as $discount)
                                        <?php $discounts += $discount->balance; ?>
                                    @endforeach
                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;">Sales Discount</td>
                                        <td style="width: 30%;text-align: right;padding: 4px;">
                                            {{ number_format($discounts, 2) }}</td>
                                    </tr>

                                    <tr>
                                        <td style="width: 70%;text-align: left;font-weight: bold;padding: 4px;">Net
                                            Sales</td>
                                        <td
                                            style="width: 30%;text-align: right;font-weight: bold;padding: 4px;border-top: 2px solid black;">
                                            {{ number_format($gross_sales - $salesreturn - $discounts, 2) }}</td>
                                        <?php $net_sale = $gross_sales - $salesreturn - $discounts; ?>
                                    </tr>
                                </table>


                            </div>
                        </div>
                    </div>
                    <!-- Revenue table End -->

                    <!-- Inventory  table statrs -->
                    <?php $cost_of_goods_sold = 0; ?>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light">
                                <h2>Cost of Goods</h2>
                                <table style="width: 60%;margin-left: 15%;" align="left">

                                    <?php $op_inventory = 0; ?>
                                    @foreach ($opening_inventory as $opinventory)
                                        <?php $op_inventory += $opinventory->balance; ?>
                                    @endforeach

                                    <?php $cur_inventory = 0;
                                    $cur_debit = 0;
                                    $cur_credit = 0; ?>
                                    @foreach ($inventory as $inventor)
                                        <?php $cur_inventory += $inventor->balance; ?>
                                        <?php $cur_debit += $inventor->debit; ?>
                                        <?php $cur_credit += $inventor->credit; ?>
                                        <?php //echo "inventory: ".$cur_inventory." : debit :  ".$cur_debit." : credit". $cur_credit;exit;
                                        ?>
                                    @endforeach
                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;">Opening Inventory</td>
                                        <td style="width: 30%;text-align: right;padding: 4px;">
                                            {{ number_format($op_inventory, 2) }}</td>
                                    </tr>

                                    <?php $purchase = 0;
                                    $p_debit = 0;
                                    $p_credit = 0; ?>
                                    {{-- @foreach ($purchases as $purchases)
                                            <?php $purchase += $purchases->balance; ?>
                                            <?php $p_debit += $purchases->debit; ?>
                                            <?php $p_credit += $purchases->credit; ?>
                                        @endforeach --}}
                                    <?php $available_stock = $op_inventory + $p_debit; ?>
                                    <?php $clos_inventory = $op_inventory + $cur_debit - $cur_credit; ?>
                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;">Purchases</td>
                                        <td style="width: 30%;text-align: right;padding: 4px;">
                                            {{ number_format($p_debit - $p_credit, 2) }}</td>
                                    </tr>

                                    <!--tr>
                                                                               <td style="width: 70%;text-align: left;padding: 4px;">Purchase Discount</td>
                                                                               <td style="width: 30%;text-align: right;padding: 4px;">{{ number_format(0, 2) }}</td>
                                                                           </tr>-->

                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;"></td>
                                        <td
                                            style="width: 30%;text-align: right;padding: 4px;font-weight: bold;border-top: 2px solid black;">
                                            {{ number_format($available_stock, 2) }}</td>
                                    </tr>
                                    <?php $clsiingInt = 0; ?>
                                    {{-- @foreach ($closing_inventory as $closing)
                                                <?php $clsiingInt += $closing->total_value; ?>
                                            @endforeach --}}
                                    <?php //echo "inventory: ".$op_inventory." : debit :  ".$p_debit." : credit". $p_credit;exit;
                                    ?>
                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">Closing
                                            Inventory</td>
                                        <td
                                            style="width: 30%;text-align: right;padding: 4px;font-weight: bold;border-bottom: 2px solid black;">
                                            {{ number_format($clos_inventory, 2) }}</td>
                                        <?php $cost_of_goods_sold = $available_stock - $clos_inventory; //$cost_of_goods_sold = ($op_inventory + $p_debit) - $clsiingInt; ?>
                                    </tr>

                                </table>


                            </div>
                        </div>
                    </div>
                    <!-- Inventory table End -->

                    <!-- Gross Profit  table statrs -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light">
                                <br>
                                <table style="width: 85%;" align="right">
                                    <tr>
                                        <td style="width: 70%;text-align: left;font-weight: bold;padding: 4px;">Cost of
                                            Goods Sold</td>
                                        <td
                                            style="width: 30%;text-align: right;font-weight: bold;padding: 4px;border-bottom: 2px solid black;">
                                            {{ number_format($available_stock - $clos_inventory, 2) }}</td>

                                    </tr>

                                    <tr>
                                        <td style="width: 70%;text-align: left;font-weight: bold;padding: 4px;">Gross
                                            Profit</td>
                                        <td
                                            style="width: 30%;text-align: right;font-weight: bold;padding: 4px;border-bottom: 2px solid black;">
                                            {{ number_format($net_sale - $cost_of_goods_sold, 2) }}</td>
                                        <?php $gross_profit = $net_sale - $cost_of_goods_sold; ?>

                                    </tr>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- Gross Profit table End -->

                    <!-- Expanses  table statrs -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light">
                                <h2>Expenses</h2>
                                <table style="width: 60%;margin-left: 15%;" align="left">
                                    <?php $total_expenese = 0; ?>
                                    @foreach ($data_expanse['Expenses']['Admin. Expenses'] as $index => $expenses)
                                        <tr>
                                            <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">
                                                {{ $index }}</td>
                                            <td style="width: 30%;text-align: right;padding: 4px;font-weight: bold;">
                                            </td>
                                        </tr>
                                        <?php $sub_totals = 0; ?>
                                        @foreach ($expenses['details'] as $row)
                                            <tr>
                                                <td style="width: 70%;text-align: left;padding: 4px;">
                                                    {{ $row->transaction_account_name }}</td>
                                                <td style="width: 30%;text-align: right;padding: 4px;">
                                                    {{ number_format($row->debit - $row->credit, 2) }}</td>
                                            </tr>
                                            <?php $sub_totals += $row->debit - $row->credit; ?>
                                            <?php $total_expenese += $row->debit - $row->credit; ?>
                                        @endforeach
                                        <tr style="margin-top: 20px;">
                                            <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">Sub
                                                Total</td>
                                            <td
                                                style="width: 30%;text-align: right;padding: 4px;font-weight: bold;border-top: 2px solid black;">
                                                {{ number_format($sub_totals, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- Expanses table End -->

                    <!-- Net Profit  table statrs -->

                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light">
                                <table style="width: 85%;margin-left: 15%;" align="left">

                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">Total
                                            Expenses</td>
                                        <td
                                            style="width: 30%;text-align: right;padding: 4px;font-weight: bold;border-bottom: 2px solid black;">
                                            {{ number_format($total_expenese, 2) }}</td>
                                    </tr>

                                    <tr>
                                        <td style="width: 70%;text-align: left;padding: 4px;font-weight: bold;">Net
                                            Profit </td>
                                        <td
                                            style="width: 30%;text-align: right;padding: 4px;font-weight: bold;border-bottom: 2px solid black;">
                                            {{ number_format($gross_profit - $total_expenese, 2) }}</td>
                                    </tr>

                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- Net Profit table End -->

                </div>
            </div>
        </div>
    </div>
    </div>
    <?php endif; ?>



    <!-- ===== Page-Content-End ===== -->
    <!-- ===== Page-Content-End ===== -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- jQuery (required for Select2) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        jQuery(document).ready(function() {

            $('#fromdate').datepicker({
                autoclose: true,
                todayHighlight: true
            });

            $('#todate').datepicker({
                autoclose: true,
                todayHighlight: true
            });


            $('#transaction_account_from').select2();
            $('#transaction_account_to').select2();


        });
    </script>
@endsection
